function out = statd(I,Ir,b,nom,fic_out)

I = real(I);
Ir = real(Ir);

if (nargin < 3)
    b = 0;
end

if (nargin < 4)
    nom = [];
end

nom = lower(nom);

if (nargin < 5)
    fic_out = [];
end

if (size(I,3) > 1)
    out = cell(size(I,3),1);
    for k = 1:size(I,3)
        if (nargout == 0)
            fprintf(1,'--> %d/%d\n',k,size(I,3));
            statd(I(b+1:end-b,b+1:end-b,k),Ir(b+1:end-b,b+1:end-b,k),0,nom);
        else
            out{k} = statd(I(b+1:end-b,b+1:end-b,k),0,nom);
        end
    end
    return
end

I = I(b+1:end-b,b+1:end-b);
v = double(I(:));

Ir = Ir(b+1:end-b,b+1:end-b);
vr = double(Ir(:));

v0 = v(find(~isnan(v) & ~isinf(v) & ~isnan(vr) & ~isinf(vr)));
vr = vr(find(~isnan(v) & ~isinf(v) & ~isnan(vr) & ~isinf(vr)));

v = v0 - vr;
length(v)
if (isempty(nom)) | (~isempty(fic_out))
    calc_stat.min = 1;
    calc_stat.max = 1;
    calc_stat.moy = 1;
    calc_stat.med = 1;
    calc_stat.std = 1;
    calc_stat.l1 = 1;
    calc_stat.l2 = 1;
    calc_stat.eqm = 1;
    calc_stat.eqmn = 1;
    calc_stat.snr = 1;
    calc_stat.psnr = 1;
    calc_stat.ab = 1;
    calc_stat.corr  = 1;
    calc_stat.xd = 1;
    calc_stat.vt = 1;
    calc_stat.ent = 1;
    calc_stat.histo = 1;
else

    calc_stat.min = 0;
    calc_stat.max = 0;
    calc_stat.moy = 0;
    calc_stat.med = 0;
    calc_stat.std = 0;
    calc_stat.l1 = 0;
    calc_stat.l2 = 0;
    calc_stat.eqm = 0;
    calc_stat.eqmn = 0;
    calc_stat.snr = 0;
    calc_stat.psnr = 0;
    calc_stat.corr = 0;
    calc_stat.ab = 0;
    calc_stat.xd = 0;
    calc_stat.ent = 0;
    calc_stat.histo = 0;
    
    calc_stat = setfield(calc_stat,nom,1);

    if (calc_stat.ent)
        calc_stat.histo = 1;
    end
    
end    

s_stat.n = length(v);

if (calc_stat.min)
    s_stat.min = min(v);
end

if (calc_stat.max)
    s_stat.max = max(v);
end

if (calc_stat.moy)
    s_stat.moy = mean(v);
end

if (calc_stat.med)
    s_stat.med = median(v);
end

if (calc_stat.std)
    s_stat.std = std(v);
end

if (calc_stat.l2)
    s_stat.l2 = sqrt(mean(v.^2));
    s_stat.eqm = s_stat.l2;
end

if (calc_stat.eqm)
    s_stat.eqm = sqrt(mean(v.^2));
end

if (calc_stat.eqmn)
    s_stat.eqmn = sqrt(mean(v.^2))/mean(vr);
end

if (calc_stat.snr)
    eqm = sqrt(mean(v.^2));
    er = sqrt(mean(vr.^2));
    
    s_stat.snr = -20*log10(eqm/er);
end

if (calc_stat.psnr)
    eqm = sqrt(mean(v.^2));
    maxr = max(vr(:));
    
    s_stat.psnr = -20*log10(eqm/maxr);
end

if (calc_stat.l1)
    s_stat.l1 = mean(abs(v));
end

if (calc_stat.histo)
    
    N = 1024;
    if (N > length(v))
        N = length(v);
    end
    
    [h,b] = hist(v,N);
    h = h/length(v);
    hc = cumsum(h);
    
    histo.h = h;
    histo.hc = hc;
    histo.b = b;
    s_stat.histo = histo;

end    

if (calc_stat.ent)
    s_stat.ent = -sum(plog2p(h));
end


% % Variation totale
% if (calc_stat.tv) | (calc_stat.vt)
%     s_stat.tv = TV(I);
%     s_stat.vt = s_stat.tv;
% end

if (calc_stat.xd)
    C = corrcoef(v,v0);
    s_stat.xd = abs(C(1,2));
end

if (calc_stat.corr)
    C = corrcoef(v0,vr);
    s_stat.corr = abs(C(1,2));
end

if (calc_stat.ab)
    p = polyfit(v0,vr,1);
    s_stat.ab = p;
end

if (nargout == 1)
    if (isempty(nom))
        out = s_stat;
    else
        out = getfield(s_stat,nom);
    end
else
    if (isempty(nom))
    
        fp = 1;
        fprintf(fp,'MIN        = %.6f\n', s_stat.min);
        fprintf(fp,'MAX        = %.6f\n', s_stat.max);
        fprintf(fp,'MOYENNE    = %.2e\n', s_stat.moy);
        fprintf(fp,'MEDIANNE   = %.2e\n', s_stat.med);
        fprintf(fp,'ECART TYPE = %.6f\n', s_stat.std);
        fprintf(fp,'EQM        = %.6f\n', s_stat.l2);
        fprintf(fp,'EQMN       = %.3f (%.6f %%)\n', s_stat.eqmn, 100*s_stat.eqmn);
        fprintf(fp,'SNR        = %.6f dB\n', s_stat.snr);
        fprintf(fp,'PSNR       = %.6f dB\n', s_stat.psnr);
        fprintf(fp,'L1         = %.6f\n', s_stat.l1);
%         fprintf(fp,'TV         = %.6f\n', s_stat.tv);
        fprintf(fp,'ENTROPIE   = %.6f\n', s_stat.ent);
        fprintf(fp,'CORR       = %.6f %%\n', 100*s_stat.corr);
        fprintf(fp,'[A B]      = [%.2e %.2e]\n', s_stat.ab(1), s_stat.ab(2));
        fprintf(fp,'XD         = %.6f %%\n', 100*s_stat.xd);
        
    else
        out = getfield(s_stat,nom);
        disp([upper(nom) ' = ' num2str(out,'%.6f')]);
    end
end

if (~isempty(fic_out))

    fp = fopen(fic_out,'wt');
    
    fprintf(fp,'MIN        = %.6f\n', s_stat.min);
    fprintf(fp,'MAX        = %.6f\n', s_stat.max);
    fprintf(fp,'MOYENNE    = %.2e\n', s_stat.moy);
    fprintf(fp,'MEDIANNE   = %.2e\n', s_stat.med);
    fprintf(fp,'ECART TYPE = %.6f\n', s_stat.std);
    fprintf(fp,'EQM        = %.6f\n', s_stat.l2);
    fprintf(fp,'SNR        = %.6f dB\n', s_stat.snr);
    fprintf(fp,'PSNR       = %.6f dB\n', s_stat.psnr);
    fprintf(fp,'L1         = %.6f\n', s_stat.l1);
    fprintf(fp,'TV         = %.6f\n', s_stat.tv);
    fprintf(fp,'ENTROPIE   = %.6f\n', s_stat.ent);
    fprintf(fp,'CORR       = %.6f %%\n', 100*s_stat.corr);
    fprintf(fp,'[A B]      = [%.2e %.2e]\n', s_stat.ab(1), s_stat.ab(2));
    fprintf(fp,'XD         = %.6f %%\n', 100*s_stat.xd);
    
    fclose(fp)
    
end


function r = plog2p(p)

ind = find(p > eps);
r = zeros(size(p));

r(ind) = p(ind).*log2(p(ind));

function nTV = TV(I)

epsilon = 1e-3;

I = double(I);
[ny,nx] = size(I);

nTV = 0;

for y = 1:ny-1,
    for x = 1:nx-1,
        
        if(x<=nx-1)
            E= I(y,x+1)-I(y,x);
        else
            E=0.;
        end
        
        if(x > 1)
            W = I(y,x)-I(y,x-1);
        else
            W=0.;
        end
        
        if(y<=ny-1)
            S=I(y+1,x)-I(y,x);
        else
            S=0.;
        end
        
        if(y > 1)
            N=I(y,x)-I(y-1,x);
        else
            N=0.;
        end
	
        nTV = nTV + 0.25*(sqrt(epsilon+E^2+S^2)+sqrt(epsilon+E^2+N^2)+sqrt(epsilon+N^2+W^2)+sqrt(epsilon+W^2+S^2));
         
    end
end

nTV = nTV/(nx*ny);

