%system2   Execute system command and return result.
%   [status,result] = system2('command') calls upon the operating system to
%   execute the given command.  The resulting status and standard output
%   are returned.
%
%   This function replaces the SYSTEM, DOS and UNIX functions.
%   It avoids a conflict between Matlab dynamic libraries and system libraries 
%   (see http://trac.oie-lab.net/ticket/294).
%
%   Examples:
%       [status,result] = system2('dir')
%       [status,result] = system2('ls')
%   returns status = 0 and, in result, a MATLAB string containing a list of
%   files in the current directory (assuming your operating system knows
%   about the "dir" or "ls" command).  If "dir" or "ls" fails or does not
%   exist on your system2, system2 returns a nonzero value in status, and an
%   explanatory message in result.

function [status,result] = system2( command )

% By default, on Linux, Matlab dynamic libraries conflict with system libraries
% => we put Linux's system library folders first in $LD_LIBRARY_PATH.
% TODO Adapt path below for distributions other than Ubuntu 12 and 14 64bits.
if isunix
    matlab_path = getenv('LD_LIBRARY_PATH');
    setenv('LD_LIBRARY_PATH', ['/usr/local/lib:/usr/lib/x86_64-linux-gnu:/lib/x86_64-linux-gnu:/usr/lib:' matlab_path]);
end

if nargout == 2
    [status,result] = system( command );
else
    status = system( command );
end    

% Restore Matlab's $LD_LIBRARY_PATH
if isunix
    setenv('LD_LIBRARY_PATH', matlab_path);
end

