function year = yearnum(varargin)
%YEARNUM Ordinal year number.
%
%   YEARNUM(YEAR, MONTH, DAY, HOUR, MIN, SEC) returns the ordinal year
%   number plus a fractional part depending on the month, day, and time of
%   day.
%
%   Any missing MONTH or DAY will be replaced by ones.  Any missing HOUR,
%   MINUTE or SECOND will be replaced by zeros.
%
%   If no date is specified, the current date and time is used.  Gregorian
%   calendar is assumed.

%   Author:      Peter John Acklam
%   Time-stamp:  2004-09-20 09:23:03 +0200
%   E-mail:      pjacklam@online.no
%   URL:         http://home.online.no/~pjacklam

   nargsin = nargin;
   narginchk(0, 6);
   if nargsin
      argv = {1 1 1 0 0 0};
      argv(1:nargsin) = varargin;
   else
      argv = num2cell(clock);
   end
   [year, month, day, hour, minute, second] = deal(argv{:});

   year = year + (dayofyear(year, month, day, hour, minute, second) - 1) ...
          ./ daysinyear(year);
