function vc(varargin)
%vc Display a 3D array image by image.
%   vc(I) displays the matrix I image by image.  
%   I is a matrix of dimension MxNxF, where F is the number of frames, 
%   and can contain double, uint8, or uint16 data.
%
%   vc(I, CLIM) where CLIM = [CLOW CHIGH] can specify the scaling.

I = varargin{1};
if (length(size(I)) == 3)
    % LS 07-2018: if no clim parameter, compute fixed scaling
    if (nargin < 2)
        min_I = nanmin(nanmin(nanmin(I)));
        max_I = nanmax(nanmax(nanmax(I)));
        clim = [min_I max_I];
        vc(I, clim);
        return
    end
    
    % display the matrix I image by image
    nb_images = size(I,3);
    fig = gcf; % get handle to current figure
    for k = 1:nb_images,
        % draw 1 frame
        figure(fig)
        vc(varargin{1}(:,:,k),varargin{2:end});
        titre = sprintf('Image %d/%d\nPress a key for next image\nClose this window to stop the animation', k, nb_images);
        title(titre);
        
        % wait for key press or mouse-button click
        try
            waitforbuttonpress 
        catch
        end
        
        % stop if user closed the figure
        if (ishandle(fig) == 0)
            return
        end
    end
    return
elseif (length(size(I)) ~= 2)
    error('');
end

if (~any(I))
% 	warning('Image nulle');
    clf
	imagesc(I), axis image
	return
end

mimag = max(abs(imag(I(:))))/max(abs((I(:))));
if (mimag > 1e-10)
	subplot(1,2,1),vc(abs(I));
	subplot(1,2,2),vc((angle(I)).*(abs(I)>1e-3*max(abs((I(:))))));
	return
else
	I = real(I);
end

if (nargin >= 2)
	clim = varargin{2};
	imagesc(I,clim),colormap(jet),axis image;
else
	imagesc(I),colormap(jet),axis image;
end

colorbar
figure(gcf)


