function vc_xy(varargin)
%vc_xy Display 3D array image by image.
%   vc_xy(X,Y,I) displays matrix I image by image.  
%   I is a matrix of dimension MxNxF, where F is the number of frames, 
%   and can contain double, uint8, or uint16 data.
%   X and Y are vectors specifying the locations
%   of the pixel centers of I(1,1) and I(M,N).  Element I(1,1) is
%   centered over (X(1), Y(1)), element I(M,N) is centered over
%   (X(end), Y(end)), and the pixel centers of the remaining elements
%   of I are spread out evenly between those two points, so that the
%   rectilinear patches are all of equal width and height.
%
%   vc_xy(X,Y,I,CLIM) where CLIM = [CLOW CHIGH] can specify the scaling.

x = varargin{1};
y = varargin{2};
I = varargin{3};
if (length(size(I)) == 3)
    nk = size(I,3);
    for k = 1:nk,
        figure(gcf)
        vc_xy(x,y,I(:,:,k),varargin{4:end});
        titre = sprintf('Image %d/%d', k, nk);
        title(titre);
        pause
    end
    return
elseif (length(size(I)) ~= 2)
    error('');
end

if (~any(I))
	warning('Image nulle');
    clf
	imagesc(x,y,I), axis xy
	return
end

mimag = max(abs(imag(I(:))))/max(abs((I(:))));
if (mimag > 1e-10)
	subplot(1,2,1),vc_xy(x,y,abs(I));
	subplot(1,2,2),vc_xy(x,y,(angle(I)).*(abs(I)>1e-3*max(abs((I(:))))));
	return
else
	I = real(I);
end

if (nargin >= 4)
	clim = varargin{2};
	imagesc(x,y,I,clim),colormap(jet),axis xy;
else
	imagesc(x,y,I),colormap(jet),axis xy;
end



colorbar
figure(gcf)


