function varargout = vd(varargin)
% vd M-file for vd.fig
%      vd, by itself, creates a new vd or raises the existing
%      singleton*.
%
%      H = vd returns the handle to a new vd or the handle to
%      the existing singleton*.
%
%      vd('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in vd.M with the given input arguments.
%
%      vd('Property','Value',...) creates a new vd or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before vd_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to vd_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help vd

% Last Modified by GUIDE v2.5 04-Mar-2003 11:18:21

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @vd_OpeningFcn, ...
    'gui_OutputFcn',  @vd_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before vd is made visible.
function vd_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to vd (see VARARGIN)

% Choose default command line output for vd

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes vd wait for user response (see UIRESUME)
% uiwait(handles.Main);

% Stockage des donnes de visualisation
V.A = varargin{1};
V.B = varargin{2};

[nl,nc] = size(V.A);
if (any([nl,nc]>512))
	V.A = V.A(1:512,1:512);
end
if (any([nl,nc]<512))
	V.A(512,512)=nan;
end

[nl,nc] = size(V.B);
if (any([nl,nc]>512))
	V.B = V.B(1:512,1:512);
end
if (any([nl,nc]<512))
	V.B(512,512)=nan;
end


if (length(varargin) > 2)
    V.R = varargin{3};
else
    V.R = [];
end

V.zoom = 1;
V.zone = [1 1 512 512];

% Evaluation des deux lut
I = [V.A V.B];
I = I(:);

minI = max(1,floor(min(I)));
maxI = min(256,floor(max(I)+1));

h = zeros(256,1);
h(minI:maxI) = linspace(0,1,maxI-minI+1);
V.map1 = [h h h];

% [J,hc] = histeq(uint8(I+0.5),256);
hc = cumsum(hist(I,256));
hc = hc'/max(hc);
V.map2 = [hc(:) hc(:) hc(:)];
V.map = V.map1;
V.reponse = 2;

set(hObject,'UserData',V);

% Initialisation
set(handles.Main,'DoubleBuffer','on');
set(handles.zoom,'Value',1);
set(handles.egalisation,'Value',0);
set(handles.blink,'UserData',1);

Visu(handles);
VisuZ(handles);


uiwait(handles.Main);


% --- Outputs from this function are returned to the command line.
function varargout = vd_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
V = get(handles.Main,'UserData');
varargout{1} = V.reponse;

% The figure can be deleted now
delete(handles.Main);

% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on button press in blink.
function blink_Callback(hObject, eventdata, handles)
% hObject    handle to blink (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

V = get(handles.Main,'UserData');

blink = get(hObject,'UserData');
set(hObject,'UserData',~blink);

x = [V.zone(2):1:V.zone(2)+V.zone(4)-1];
y = [V.zone(1):1:V.zone(1)+V.zone(3)-1];

axes(handles.axesA);
if (blink)
    image(x,y,V.B(x,y)),axis image, colormap(V.map),title('B');
else
    image(x,y,V.A(x,y)),axis image, colormap(V.map),title('A');
end

% --- Executes on button press in egalisation.
function egalisation_Callback(hObject, eventdata, handles)
% hObject    handle to egalisation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of egalisation


V = get(handles.Main,'UserData');
if (get(hObject,'Value') == 1)
    V.map = V.map2;
else
    V.map = V.map1;
end

set(handles.Main,'UserData',V);
Visu(handles);


% --- Executes during object creation, after setting all properties.
function zoom_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zoom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in zoom.
function zoom_Callback(hObject, eventdata, handles)
% hObject    handle to zoom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns zoom contents as cell array
%        contents{get(hObject,'Value')} returns selected item from zoom

V = get(handles.Main,'UserData');
V.zoom = 2^(get(hObject,'Value')-1);
V.zone(1:2) = [1 1];
V.zone(3:4) = [512 512]/V.zoom;
set(handles.Main,'UserData',V);
VisuZ(handles);
Visu(handles);

% --- Executes on mouse press over axes background.
function axesZ_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axesZ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

V = get(handles.Main,'UserData');

if (V.zoom > 1)
    
    p = get(hObject,'CurrentPoint');
    q = p(1,1:2);
    qx = q(2);
    qy = q(1);
    
    qx = max(1,qx);
    qx = min(qx,512-V.zone(4));
    
    qy = max(1,qy);
    qy = min(qy,512-V.zone(3));
    
    V.zone(1) = floor(qy + 0.5);
    V.zone(2) = floor(qx + 0.5);
    
end

set(handles.Main,'UserData',V);
Visu(handles);
VisuZ(handles);

% --- Executes on mouse press over axes background.



% % --- Executes on mouse press over figure background.
% function Main_ButtonDownFcn(hObject, eventdata, handles)
% % hObject    handle to Main (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)


% Visualisation des images
function Visu(handles)

V = get(handles.Main,'UserData');

x = [V.zone(2):1:V.zone(2)+V.zone(4)-1];
y = [V.zone(1):1:V.zone(1)+V.zone(3)-1];

axes(handles.axesA);
image(x,y,V.A(x,y)),axis image, colormap(V.map),title('A');

if (get(handles.diff,'Value'))
    axes(handles.axesB);
    D = V.B(x,y)-V.A(x,y);
    if ~(get(handles.egalisation,'Value'))
        imagesc(x,y,D),colormap(gray(256)),axis image,title('B-A');
    else
		hc = cumsum(hist(D(:),256));
		hc = hc'/max(hc);
		map = [hc hc hc];
        image(x,y,D),colormap(map),axis image,title('B-A');
    end
else
    axes(handles.axesB);
    image(x,y,V.B(x,y)),axis image, colormap(V.map),title('B');
end


function VisuZ(handles)

V = get(handles.Main,'UserData');

axes(handles.axesZ);
% imagesc(1:4:512,1:4:512,V.A(1:4:512,1:4:end)),axis image
% hold on
x0 = V.zone(1);
x1 = V.zone(1) + V.zone(3)-1;
y0 = V.zone(2);
y1 = V.zone(2) + V.zone(4)-1;
plot([x0 x0 x1 x1 x0],[y0 y1 y1 y0 y0],'r'),axis ij,axis([1 512 1 512]);
% hold off
% 
set(handles.axesZ,'ButtonDownFcn','vd(''axesZ_ButtonDownFcn'',gcbo,[],guidata(gcbo))');


% --- Executes on button press in diff.
function diff_Callback(hObject, eventdata, handles)
% hObject    handle to diff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Visu(handles);

% --- Executes when user attempts to close Main.
function Main_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to Main (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isequal(get(handles.Main, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(handles.Main);
else
    % The GUI is no longer waiting, just close it
    delete(handles.Main);
end


% --- Executes on key press over Main with no controls selected.
function Main_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Main (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

key = get(hObject,'CurrentCharacter');
key = lower(key);

V = get(handles.Main,'UserData');

if (double(key) >= 49) & (double(key) <= 57)
    fp = fopen('zones.mat','r');
    if (fp ~= -1)
        fclose(fp);
        load zones
        nz = length(zones);
        kz = double(key)-48;
        if (kz <= nz)
            
            disp(['Chargement de la zone ' num2str(kz)])
            V.zone = zones{kz};
            V.zoom = 512/V.zone(3);
            z = nextpow2(V.zoom) + 1;
            set(handles.Main,'UserData',V);
            set(handles.zoom,'Value',z);

            Visu(handles);
            VisuZ(handles);
            
        end
    end
    return
end


switch(key)
    
    case 's'
        
        if (~isempty(V.R))
            % Affichage des statiques
            disp('Image A - Reference :: ')
            eqm(V.A,V.R,32);
            disp('Image B - Reference :: ')
            eqm(V.B,V.R,32);
        end
        
    case 'b'
        
        vd('blink_Callback',handles.blink, eventdata, handles);
        
    case 'a'
        
        z = get(handles.zoom,'Value');
        if (z > 1)
            z = mod(z-1,4);
            
            set(handles.zoom,'Value',z);
            vd('zoom_Callback',handles.zoom, eventdata, handles);
        end
        
    case 'z'
        
        z = get(handles.zoom,'Value');
        if (z < 4)
            z = mod(z,4) + 1;
            
            set(handles.zoom,'Value',z);
            vd('zoom_Callback',handles.zoom, eventdata, handles);
        end
        
    case 'x'
        
        % test l''existence
        fp = fopen('zones.mat','r');
        if (fp == -1)
            zones{1} = V.zone;
            disp(['Chargement de la zone dans : 1']);
                            
            save zones zones
        else
            fclose(fp);
            load zones
            nz = length(zones);
            if (nz >= 9)
                warning('Plus de 9 zones dfinies : impossible');
            else
                nz = nz + 1;
                disp(['Sauvegarde de la zone dans : ' num2str(nz)]);
                zones{nz} = V.zone;
                save zones zones
            end
            
        end
        
    case 'c'
        
        fp = fopen('zones.mat','r');
        if (fp ~= -1)
            fclose(fp);
            delete('zones.mat');
            disp('Effacement des zones');
        end
        
    otherwise
        
end


% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes during object creation, after setting all properties.
function note_CreateFcn(hObject, eventdata, handles)
% hObject    handle to note (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in note.
function note_Callback(hObject, eventdata, handles)
% hObject    handle to note (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns note contents as cell array
%        contents{get(hObject,'Value')} returns selected item from note


V = get(handles.Main,'UserData');
v = get(handles.note,'Value');

V.reponse = (3-v);
set(handles.Main,'UserData',V);


% --- Executes on button press in ok.
function ok_Callback(hObject, eventdata, handles)
% hObject    handle to ok (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Update handles structure
guidata(hObject, handles);

% Use UIRESUME instead of delete because the OutputFcn needs
% to get the updated handles structure.
uiresume(handles.Main);

