function vf(varargin)

I = varargin{1};

NI = length(I);
N = 2^nextpow2(NI/4);

DSPI = dsp2d(I,N,'blackman_h4t');

FI = 20*log10(DSPI);

N = length(FI);
f = mkf(N);

if (nargin == 1)
   imagesc(f,f,FI),colormap(jet(256)),axis image;
else
   cm = varargin{2};
   imagesc(f,f,FI,cm),colormap(jet(256)),axis image;
end

colorbar
figure(gcf)

%axis off
colorbar;
%zoom on