function vg(varargin)
% vg(image,'
I = varargin{1};

if (iscell(I))
    nk = length(I);
    for k = 1:nk,
        figure(gcf)
        vg(I{k},varargin{2:end});
        titre = sprintf('Image %d/%d', k, nk);
        title(titre);
        pause
    end
	return
end

if (length(size(I)) == 3)
    nk = size(I,3);
    k = 0;
    
    while (1)
        figure(gcf)
        vg(varargin{1}(:,:,mod(k,nk) + 1),varargin{3:end});
        titre = sprintf('Image %d/%d', mod(k,nk) + 1, nk);
        title(titre);
        k = k + 1;
        if (nargin > 1)
            pause(varargin{2})
        else
            pause
        end
    end
    return
elseif (length(size(I)) ~= 2)
    error('');
end

if (~any(I))
	warning('Image nulle');
	imagesc(I), axis image
	return
end

mimag = max(abs(imag(I(:))))/max(abs((I(:))));
if (mimag > 1e-10)
	subplot(1,2,1),vg(abs(I));
	subplot(1,2,2),vg((angle(I)).*(abs(I)>1e-3*max(abs((I(:))))));
	return
else
	I = real(I);
    subplot(1,1,1);
end

if (nargin == 3)
    I = ext_zone(I,varargin{3},'i');
    vg(I,varargin{2});
end

if (nargin == 2)
	if (length(varargin{2}) == 2)
		clim = varargin{2};
		imagesc(I,clim),colormap(gray),axis image;
	elseif (ischar(varargin{2}))
		[h,b] = hist(I(:),256);
        hc = cumsum(h)/sum(h);
		switch (lower(varargin{2}(1)))
			case 'e'
				e = 0.001;
				ind = find((hc<e)&(hc>1-e));
                h(ind) = 0;
                hc = cumsum(h)/sum(h);
				ind = find((hc<=1-e)&(hc>=e));
				clim = [b(min(ind)) b(max(ind))];
				map = [hc' hc' hc'];
				imagesc(I,clim),colormap(map),axis image;
			case 's'				
				e = 0.03;
				ind = find((hc<=1-e)&(hc>=e));
				clim = [b(min(ind)) b(max(ind))];
				imagesc(I,clim),colormap(gray),axis image;				
			otherwise
				error('Mauvais parametrage');
        end				
	else
		vg(I);
	end
else
	imagesc(I),colormap(gray),axis image;
end


figure(gcf)


