function vm(I1,I2,map,zone,zoom,t)
% vm(I1,I2,map,[zone],zoom, t)

if (nargin < 3)
    map = 's';
end

if (nargin < 4)
    zone = [];
else
    if (~isempty(zone))
        I1 = ext_zone(I1,zone,'i');
        I2 = ext_zone(I2,zone,'i');
    end
end

if (nargin >= 5)

    I1 = zoomima(I1,zoom,7);
    I2 = zoomima(I2,zoom,7);

end

if (nargin < 6)
    t = -1;
end

I = [I1(:);I2(:)];

[h,b] = hist(I(:),256);
hc = cumsum(h)/sum(h);
mapeg = gray(256);

if (nargin >= 2)
    if (~isempty(map))
        switch (lower(map(1)))
            case 'e'
                e = 0.001;
                ind = find((hc<e)&(hc>1-e));
                h(ind) = 0;
                hc = cumsum(h)/sum(h);
                ind = find((hc<=1-e)&(hc>=e));
                clim = [b(min(ind)) b(max(ind))];
                mapeg = [hc' hc' hc'];
            case 's'
                e = 0.03;
                ind = find((hc<=1-e)&(hc>=e));
                clim = [b(min(ind)) b(max(ind))];
            otherwise
                clim = [max(I(:)) min(I(:))];
        end
    else
        clim = [min(I(:)) max(I(:))];
    end
end

figure(gcf)
clf

set(gcf,'DoubleBuffer','on');

fin = 0;

D = I1(:)-I2(:);
psnr = 20*log10(255/std(D));

msg1 = sprintf('Image 1 - PSNR = %.2f dB', psnr);
msg2 = sprintf('Image 2 - PSNR = %.2f dB', psnr);

minI1 = min(I1(:));
maxI1 = max(I1(:));

while (fin == 0)

    imagesc(I1,clim),colormap(mapeg),axis image,title(msg1);

    if (t < 0)
        pause
    else
        pause(t)
    end


    imagesc(I2,clim),colormap(mapeg),axis image,title(msg2);

    if (t < 0)
        pause
    else
        pause(t)
    end
 
end

