function vp(c,mode)

if (nargin == 1)
   mode = 'c';
end

h_f = gcf;

if (~ishold)
   ho = 0;
   clf;
else
   ho = 1;
end

axis equal

couleur = 0;

if (size(c,2) ~= 3) & (size(c,2) ~= 4)
   error('C doit tre de taille N,3 ou N,4');
end

switch(mode)
case 's'
   
   sc = support_ftm_so(c,'reduit');
   c = sc;
   mode = 'd';
   
case 'f3d'
   
   N = 128;
   sc = support_ftm_so(c,'normal');
   maxFx = max(sc(:,1)+sc(:,3));
   maxFy = max(sc(:,2)+sc(:,3));
   maxF = max(maxFx,maxFy);
   
   f = linspace(-maxF,maxF-2*maxF/N,N);
   [fx,fy] = meshgrid(f,f);
   Ftm = calc_ftm_so(c,fx,fy);
   surf(f,f,Ftm);
   shading interp
   colorbar
   return
   
case 'f'
   
   N = 128;
   sc = support_ftm_so(c,'normal');
   maxFx = max(sc(:,1)+sc(:,3));
   maxFy = max(sc(:,2)+sc(:,3));
   maxF = max(maxFx,maxFy);
   
   f = linspace(-maxF,maxF-2*maxF/N,N);
   [fx,fy] = meshgrid(f,f);
   Ftm = calc_ftm_so(c,fx,fy);
   imagesc(f,f,Ftm)
   colormap(jet);
   axis equal
   colorbar
   return
   
case 'af'
   
   N = 128;
   sc = support_ftm_so(c,'normal');
   maxFx = max(sc(:,1)+sc(:,3));
   maxFy = max(sc(:,2)+sc(:,3));
   maxF = max(maxFx,maxFy);
   
   rof = linspace(0,maxF-2*maxF/N,N);
   af = linspace(-pi,pi,N);
   
   [vrof,vaf] = meshgrid(rof,af);
   fx = vrof.*cos(vaf);
   fy = vrof.*sin(vaf);
   
   Ftm = calc_ftm_so(c,fx,fy);
   imagesc(af*180/pi,rof,Ftm')
   ylabel('|f_x + if_y|')
   xlabel('Angle(f_x + if_y) ()')
   colormap(jet);
   colorbar
   return
   
case 'fs'
   
   N = 128;
   sc = support_ftm_so(c,'normal');
   maxFx = max(sc(:,1)+sc(:,3));
   maxFy = max(sc(:,2)+sc(:,3));
   maxF = max(maxFx,maxFy);
   
   f = linspace(-maxF,maxF-2*maxF/N,N);
   [fx,fy] = meshgrid(f,f);
   Ftm = calc_ftm_so(c,fx,fy);
   clb = contour(f,f,Ftm,[0:0.01:0.05 0.075 0.1:0.1:1]);
   clabel(clb);
   colormap(jet);
   axis equal
   colorbar
   return
   
case 'sf'
   
   N = 128;
   sc = support_ftm_so(c,'normal');
   maxFx = max(sc(:,1)+sc(:,3));
   maxFy = max(sc(:,2)+sc(:,3));
   maxF = max(maxFx,maxFy);
   
   f = linspace(-maxF,maxF-2*maxF/N,N);
   [fx,fy] = meshgrid(f,f);
   [Ftm,sFtm] = calc_ftm_so(c,fx,fy);
   imagesc(f,f,sFtm)
   colormap(jet);
   axis equal
   colorbar
   return
   
end


np = size(c,1);

if (size(c,2) == 4)
   obst = 1;
else 
   obst = 0;
end

for kp=1:np,
   
   ci = circle(c(kp,3),c(kp,1),c(kp,2),64);   
   if (obst)
      cio = circle(c(kp,4),c(kp,1),c(kp,2),64);   
   end
   
   switch(lower(mode(1)))
   case 'c'
      
      h=patch(ci(1,:),ci(2,:),nan);
      if (obst)
         ho=patch(cio(1,:),cio(2,:),'k');
      end
      
      if (length(mode)==1)
         set(h,'EdgeColor','k')
      else
         set(h,'EdgeColor',mode(2))
      end
      %set(h,'EraseMode','xor')
      
      hold on
      grid on
      
   case 'd'
      couleur = 0;      
      if (length(mode)==1)      
         
         if (size(c,2)>=4)
            h=patch(ci(1,:),ci(2,:),c(kp,4));
            couleur = 1;
         else
            h=patch(ci(1,:),ci(2,:),'k');
         end
         
      else   
         h=patch(ci(1,:),ci(2,:),mode(2:end));
      end
      
      if (length(mode) <= 2)      
         set(h,'EdgeColor','b')
      else
         set(h,'EdgeColor',mode(3))
      end
      %set(h,'EraseMode','xor')
      
      hold on
      grid on
      
   otherwise
      error('Mode non support')
   end
   
   t_hp(kp) = h;
   
end

if (couleur)
   colorbar
end

% Mise en ordre des patchs

h_a = get(h_f,'CurrentAxes');
t_hc = get(h_a,'children');

nc = length(t_hc);
rayon = zeros(nc,1);

for k = 1:nc,
   
   ind = find(t_hp==t_hc(k));
   if (isempty(ind))
      rayon(k) = -1;
   else
      rayon(k) = c(ind,3);
   end
   
end

[rs,ind_rs] = sort(rayon);
ind_rs = fliplr(ind_rs);

new_t_hc = t_hc(ind_rs);
set(h_a,'children',new_t_hc);

if (ho == 0)
   hold off;
end