function vrgb(I,mode)

if (size(I,3)<3)
    error('L''image en entre doit avoir au moins trois canaux');
end
I = double(I(:,:,1:3));

if (nargin < 2)
    mode = 'sc';
end

nv = 256;

vI = I(:);
v_g = linspace(min(vI),max(vI),nv);
h_g = histc(vI,v_g);
idx = find(h_g>0);
v_g = v_g(idx);
h_g = h_g(idx);
hc_g = cumsum(h_g);
hc_g = (hc_g-hc_g(1))/(hc_g(end)-hc_g(1));

for k = 1:3,
    Ik = I(:,:,k);
    vI = Ik(:);
    v{k} = linspace(min(vI),max(vI),nv);
    h{k} = histc(vI,v{k});
    idx = find(h{k}>0);
    v{k} = v{k}(idx);
    h{k} = h{k}(idx);
    hc{k} = cumsum(h{k});
    hc{k} = (hc{k}-hc{k}(1))/(hc{k}(end)-hc{k}(1));
end

switch(mode)
    case 'sg'
        p = 2.5/100;
        minIp = interp1(hc_g, v_g, p, 'lin');
        maxIp = interp1(hc_g, v_g, 1-p, 'lin');
        a = 255/(maxIp-minIp);
        b = -a*minIp;
        J = a*I + b;
        J(J<0) = 0;
        J(J>255) = 255;
        J = uint8(J+0.5);
        image(J),axis image
    case 'sc'
        p = 2.5/100;
        J = zeros(size(I));
        for k = 1:3,
            minIp = interp1(hc{k}, v{k}, p, 'lin');
            maxIp = interp1(hc{k}, v{k}, 1-p, 'lin');
            a = 255/(maxIp-minIp);
            b = -a*minIp;
            J(:,:,k) = a*I(:,:,k) + b;
        end
        J(J<0) = 0;
        J(J>255) = 255;
        J = uint8(J);
        image(J),axis image
end

