function vs(x,y,A,B)

f1 = figure(1);
set(f1,'Position',[78   303   539   439]);
clf

f2 = figure(2);
set(f2,'Position',[625   303   472   439]);
clf

N = length(A);

ok = 1;

rmax = sqrt(max(abs(x))^2+max(abs(y))^2);
xmin = min(x);
ymin = min(y);
xmax = max(x);
ymax = max(y);

M = A;
if (nargin >= 4)
    P = B;
else
    B = [];
    P = [];
end

figure(f1)
imagesc(x,y,M),axis image, colorbar, colormap('jet')

while (ok)
    
    figure(f1)
    [xb,yb,b] = ginput(1);
    
    figure(f1)
    imagesc(x,y,M),axis image, colorbar, colormap('jet')
    
    switch(b)
        case 1            
            a = angle(xb+i*yb);
            r = abs(xb+i*yb);
        case 2
            a = 0;
            r = xmax;
        case 3
            a = pi/2;
            r = ymax;            
        case double('a')
            if (~isempty(B))
                M = A;
                P = B;
            end
        case double('z')
            if (~isempty(B))
                M = B;
                P = A;
                figure(f1)
                imagesc(x,y,M),axis image, colorbar, colormap('jet')
            end
        otherwise
            ok = 0;
    end
    
    if (ok)
        
        vr = linspace(-r,r-2*r/N,N);
        
        xd = vr.*cos(a);
        yd = vr.*sin(a);
        
        figure(f1)
        hold on
        plot(xd,yd,'r')
        hold off
        
        drawnow
        
        vM = interp2(x,y,M,xd,yd,'linear');
        figure(f2)
        plot(vr,vM,'b')
        
        if (~isempty(P))
            hold on
            vP = interp2(x,y,P,xd,yd);
            figure(f2)
            plot(vr,vP,'b--')            
        end
        hold off
    end
    
end
