function [ lat, lon ] = wgs84_pixel_to_latlon(MAP_LAT_MAX, MAP_LON_MIN, MAP_LAT_RATIO, MAP_LON_RATIO, col, row)
% wgs84_pixel_to_latlon(MAP_LAT_MAX, MAP_LON_MIN, MAP_LAT_RATIO, MAP_LON_RATIO, col, row) 
% converts WGS84 pixel (1-based) to (lat, lon) in degrees.
% (MAP_LAT_MAX, MAP_LON_MIN) defines the (top, left) corner of the grid frame, in degrees
% (MAP_LAT_RATIO, MAP_LON_RATIO) defines the lat x lon ratios wrt degrees, e.g. (120, 120)

assert(MAP_LAT_RATIO > 0);
assert(MAP_LON_RATIO > 0);
assert(col >= 0.5);
assert(row >= 0.5);

lat = MAP_LAT_MAX - (row - 0.5)/MAP_LAT_RATIO;
lon = MAP_LON_MIN + (col - 0.5)/MAP_LON_RATIO;
